/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : D/I and D/O
/* - Contents:  α׷ COMI_DO_PutOne(..) COMI_DI_GetOne(..) Լ 
/*     Ͽ  1äο  D/I D/O ϴ Դϴ.
/* - Remarks : 
/*     1.   COMI-SD101 带 ϴ  ۼǾϴ.
/*         ٸ 带 ϴ 쿡 COMI_LoadDevice(...)Լ 
/*        ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/*     2.  α׷ D/O ä 0 Ͽ On/Off ȣ ư鼭 
/*        D/I ä 0 о̴ α׷Դϴ. D/O 0 äΰ D/I 0 ä 
/*         س D/O  ȣ D/I äο оϼ ֽϴ.
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "Comidas.h"

#define DEV_ID	COMI_SD101
#define DO_CH	0
#define DI_CH	0

void main (void)
{
	HANDLE hDevice;
	int do_state=0, di_state;

	if(!COMI_LoadDll()){
		printf("Comidas.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	hDevice = COMI_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDll();
		exit(0);
	}

	printf("DIO ׽Ʈ Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();
	
	/*   Digital Input/Output   ϴ ̹Ƿ	*/
	/* COMI-CP401  쿡 DI/DO   ϱ  		*/
	/* ⼭ COMI_DIO_SetUsage(DO_DI)  ־ մϴ.  		*/
	if(DEV_ID == COMI_CP401)
		COMI_DIO_SetUsage(hDevice, DO_DI);
		
	while(!kbhit())
	{
		do_state ^= 1;  // state  
		COMI_DO_PutOne (hDevice, DO_CH, do_state); // Put D/O  
		
		/* Get D/I and print on screen */
		di_state = COMI_DI_GetOne(hDevice, DI_CH);
		printf("Status of D/I CH0 = %d\n", di_state);
		Sleep(500);
	}

	
	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}
